/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config;

import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.init.ModRegistries;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public final class SkillsConfig {
    @Configurable
    @Configurable.Synchronized
    @Configurable.Comment(value={"Allows you to disable all skills for players"})
    public boolean disableAllSkills = false;
    @Configurable
    @Configurable.Range(min=1L, max=20L)
    @Configurable.Comment(value={"Specify minimum nutrition value for Well Fed skill to be triggered"})
    public int wellFedTriggerValue = 14;
    @Configurable
    @Configurable.StringPattern(value="[a-z0-9_.-]+:[a-z0-9/._-]+", defaultValue="gunsrpg:like_a_cat_i")
    @Configurable.ValueUpdateCallback(method="validateSkillIds")
    @Configurable.Comment(value={"Skills which can be access via quick-activation, max 5 supported"})
    public String[] boundSkills = new String[]{"gunsrpg:like_a_cat_i", "gunsrpg:iron_buddy_i", "gunsrpg:god_help_us"};
    @Configurable
    @Configurable.StringPattern(value="[a-z0-9_.-]+:[a-z0-9/._-]+", defaultValue="minecraft:pig")
    @Configurable.Comment(value={"Mobs listed here cannot be insta-killed"})
    @Configurable.ValueUpdateCallback(method="onSkullCrusherBlacklistUpdate")
    @Configurable.Gui.CharacterLimit(value=64)
    public String[] skullCrusherIgnoredMobs = new String[]{"gunsrpg:bloodmoon_golem", "gunsrpg:zombie_nightmare"};
    @Configurable
    @Configurable.ValueUpdateCallback(method="onCountTrapKillsSettingChange")
    @Configurable.Comment(value={"Kills by traps will be awarded to their owners", "BEWARE: This may fail some of your quests"})
    public boolean countTrapKills = true;
    private final Lazy<Set<EntityType<?>>> instantKillBlackList = Lazy.of(() -> {
        HashSet set = new HashSet();
        this.loadSkullCrusherBlacklist(set, this.skullCrusherIgnoredMobs);
        return set;
    });

    public boolean isInstantKillAllowed(EntityType<?> type) {
        return !((Set)this.instantKillBlackList.get()).contains(type);
    }

    private void onSkullCrusherBlacklistUpdate(String[] inputs, IValidationHandler handler) {
        Set blacklist = (Set)this.instantKillBlackList.get();
        blacklist.clear();
        String lastInvalidId = this.loadSkullCrusherBlacklist(blacklist, inputs);
        if (lastInvalidId != null) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.invalid_id.entity", new Object[]{lastInvalidId})));
        }
    }

    private void validateSkillIds(String[] skills, IValidationHandler handler) {
        for (String s : skills) {
            ResourceLocation id = new ResourceLocation(s);
            if (ModRegistries.SKILLS.containsKey(id)) continue;
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.invalid_id.skill", new Object[]{s})));
            break;
        }
    }

    private void onCountTrapKillsSettingChange(boolean value, IValidationHandler handler) {
        if (value) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.count_trap_kills_warning")));
        }
    }

    private String loadSkullCrusherBlacklist(Collection<EntityType<?>> collection, String[] values) {
        String lastInvalidId = null;
        for (String string : values) {
            ResourceLocation id = new ResourceLocation(string);
            if (ForgeRegistries.ENTITIES.containsKey(id)) {
                collection.add((EntityType<?>)ForgeRegistries.ENTITIES.getValue(id));
                continue;
            }
            lastInvalidId = string;
            GunsRPG.log.warn("Found unknown entity ID '{}' in config under 'skullCrusherIgnoredMobs' field", (Object)string);
        }
        return lastInvalidId;
    }
}

